/**
 * Plan actions via ajax.
 *
 * @module     tool_lp/planactions
 * @copyright  2015 David Monllao
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/planactions",["jquery","core/templates","core/ajax","core/notification","core/str","tool_lp/menubar","tool_lp/dialogue"],(function($,templates,ajax,notification,str,Menubar,Dialogue){var PlanActions=function(type){if(this._type=type,"plan"===type)this._region='[data-region="plan-page"]',this._planNode='[data-region="plan-page"]',this._template="tool_lp/plan_page",this._contextMethod="tool_lp_data_for_plan_page";else{if("plans"!==type)throw new TypeError("Unexpected type.");this._region='[data-region="plans"]',this._planNode='[data-region="plan-node"]',this._template="tool_lp/plans_page",this._contextMethod="tool_lp_data_for_plans_page"}};return PlanActions.prototype._contextMethod=null,PlanActions.prototype._planNode=null,PlanActions.prototype._region=null,PlanActions.prototype._template=null,PlanActions.prototype._type=null,PlanActions.prototype._getContextArgs=function(planData){var args={};return"plan"===this._type?args={planid:planData.id}:"plans"===this._type&&(args={userid:planData.userid}),args},PlanActions.prototype.refresh=function(selector){var planData=this._findPlanData($(selector));this._callAndRefresh([],planData)},PlanActions.prototype._renderView=function(context){var self=this;return templates.render(self._template,context).then((function(newhtml,newjs){$(self._region).replaceWith(newhtml),templates.runTemplateJS(newjs)}))},PlanActions.prototype._callAndRefresh=function(calls,planData){var callKey="tool_lp/planactions:_callAndRefresh-"+Math.floor(Math.random()*Math.floor(1e3));M.util.js_pending(callKey);var self=this;return calls.push({methodname:self._contextMethod,args:self._getContextArgs(planData)}),$.when.apply($,ajax.call(calls)).then((function(){return self._renderView(arguments[arguments.length-1])})).fail(notification.exception).always((function(){return M.util.js_complete(callKey)}))},PlanActions.prototype._doDelete=function(planData){var calls=[{methodname:"core_competency_delete_plan",args:{id:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.deletePlan=function(planData){var self=this;ajax.call([{methodname:"core_competency_read_plan",args:{id:planData.id}}])[0].done((function(plan){str.get_strings([{key:"confirm",component:"moodle"},{key:"deleteplan",component:"tool_lp",param:plan.name},{key:"delete",component:"moodle"},{key:"cancel",component:"moodle"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],(function(){self._doDelete(planData)}))})).fail(notification.exception)})).fail(notification.exception)},PlanActions.prototype._doReopenPlan=function(planData){var calls=[{methodname:"core_competency_reopen_plan",args:{planid:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.reopenPlan=function(planData){var self=this;ajax.call([{methodname:"core_competency_read_plan",args:{id:planData.id}}])[0].done((function(plan){str.get_strings([{key:"confirm",component:"moodle"},{key:"reopenplanconfirm",component:"tool_lp",param:plan.name},{key:"reopenplan",component:"tool_lp"},{key:"cancel",component:"moodle"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],(function(){self._doReopenPlan(planData)}))})).fail(notification.exception)})).fail(notification.exception)},PlanActions.prototype._doCompletePlan=function(planData){var calls=[{methodname:"core_competency_complete_plan",args:{planid:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.completePlan=function(planData){var self=this;ajax.call([{methodname:"core_competency_read_plan",args:{id:planData.id}}])[0].done((function(plan){str.get_strings([{key:"confirm",component:"moodle"},{key:"completeplanconfirm",component:"tool_lp",param:plan.name},{key:"completeplan",component:"tool_lp"},{key:"cancel",component:"moodle"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],(function(){self._doCompletePlan(planData)}))})).fail(notification.exception)})).fail(notification.exception)},PlanActions.prototype._doUnlinkPlan=function(planData){var calls=[{methodname:"core_competency_unlink_plan_from_template",args:{planid:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.unlinkPlan=function(planData){var self=this;ajax.call([{methodname:"core_competency_read_plan",args:{id:planData.id}}])[0].done((function(plan){str.get_strings([{key:"confirm",component:"moodle"},{key:"unlinkplantemplateconfirm",component:"tool_lp",param:plan.name},{key:"unlinkplantemplate",component:"tool_lp"},{key:"cancel",component:"moodle"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],(function(){self._doUnlinkPlan(planData)}))})).fail(notification.exception)})).fail(notification.exception)},PlanActions.prototype._doRequestReview=function(planData){var calls=[{methodname:"core_competency_plan_request_review",args:{id:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.requestReview=function(planData){this._doRequestReview(planData)},PlanActions.prototype._doCancelReviewRequest=function(planData){var calls=[{methodname:"core_competency_plan_cancel_review_request",args:{id:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.cancelReviewRequest=function(planData){this._doCancelReviewRequest(planData)},PlanActions.prototype._doStartReview=function(planData){var calls=[{methodname:"core_competency_plan_start_review",args:{id:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.startReview=function(planData){this._doStartReview(planData)},PlanActions.prototype._doStopReview=function(planData){var calls=[{methodname:"core_competency_plan_stop_review",args:{id:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.stopReview=function(planData){this._doStopReview(planData)},PlanActions.prototype._doApprove=function(planData){var calls=[{methodname:"core_competency_approve_plan",args:{id:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.approve=function(planData){this._doApprove(planData)},PlanActions.prototype._doUnapprove=function(planData){var calls=[{methodname:"core_competency_unapprove_plan",args:{id:planData.id}}];this._callAndRefresh(calls,planData)},PlanActions.prototype.unapprove=function(planData){this._doUnapprove(planData)},PlanActions.prototype._showLinkedCoursesHandler=function(e){e.preventDefault();var competencyid=$(e.target).data("id");ajax.call([{methodname:"tool_lp_list_courses_using_competency",args:{id:competencyid}}])[0].done((function(courses){var context={courses:courses};templates.render("tool_lp/linked_courses_summary",context).done((function(html){str.get_string("linkedcourses","tool_lp").done((function(linkedcourses){new Dialogue(linkedcourses,html)})).fail(notification.exception)})).fail(notification.exception)})).fail(notification.exception)},PlanActions.prototype._eventHandler=function(method,e){e.preventDefault();var data=this._findPlanData($(e.target));this[method](data)},PlanActions.prototype._findPlanData=function(node){var data,parent=node.parentsUntil($(this._region).parent(),this._planNode);if(1!=parent.length)throw new Error("The plan node was not located.");if(void 0===(data=parent.data())||void 0===data.id)throw new Error("Plan data could not be found.");return data},PlanActions.prototype.enhanceMenubar=function(selector){Menubar.enhance(selector,{'[data-action="plan-delete"]':this._eventHandler.bind(this,"deletePlan"),'[data-action="plan-complete"]':this._eventHandler.bind(this,"completePlan"),'[data-action="plan-reopen"]':this._eventHandler.bind(this,"reopenPlan"),'[data-action="plan-unlink"]':this._eventHandler.bind(this,"unlinkPlan"),'[data-action="plan-request-review"]':this._eventHandler.bind(this,"requestReview"),'[data-action="plan-cancel-review-request"]':this._eventHandler.bind(this,"cancelReviewRequest"),'[data-action="plan-start-review"]':this._eventHandler.bind(this,"startReview"),'[data-action="plan-stop-review"]':this._eventHandler.bind(this,"stopReview"),'[data-action="plan-approve"]':this._eventHandler.bind(this,"approve"),'[data-action="plan-unapprove"]':this._eventHandler.bind(this,"unapprove")})},PlanActions.prototype.registerEvents=function(){var wrapper=$(this._region);wrapper.find('[data-action="plan-delete"]').click(this._eventHandler.bind(this,"deletePlan")),wrapper.find('[data-action="plan-complete"]').click(this._eventHandler.bind(this,"completePlan")),wrapper.find('[data-action="plan-reopen"]').click(this._eventHandler.bind(this,"reopenPlan")),wrapper.find('[data-action="plan-unlink"]').click(this._eventHandler.bind(this,"unlinkPlan")),wrapper.find('[data-action="plan-request-review"]').click(this._eventHandler.bind(this,"requestReview")),wrapper.find('[data-action="plan-cancel-review-request"]').click(this._eventHandler.bind(this,"cancelReviewRequest")),wrapper.find('[data-action="plan-start-review"]').click(this._eventHandler.bind(this,"startReview")),wrapper.find('[data-action="plan-stop-review"]').click(this._eventHandler.bind(this,"stopReview")),wrapper.find('[data-action="plan-approve"]').click(this._eventHandler.bind(this,"approve")),wrapper.find('[data-action="plan-unapprove"]').click(this._eventHandler.bind(this,"unapprove")),wrapper.find('[data-action="find-courses-link"]').click(this._showLinkedCoursesHandler.bind(this))},PlanActions}));

//# sourceMappingURL=planactions.min.js.map