<?php
require_once(__DIR__ . '/config.php');
require_once($CFG->dirroot . '/mod/customcert/lib.php');

global $DB, $CFG;

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

// Accept either idnumber OR userid
$idnumber = optional_param('idnumber', '', PARAM_RAW);
$userid   = optional_param('userid', 0, PARAM_INT);

if (empty($idnumber) && empty($userid)) {
    echo json_encode(['error' => 'Missing idnumber or userid']);
    exit;
}

// If idnumber is provided, find userid
if (!empty($idnumber)) {
    $user = $DB->get_record("{$CFG->prefix}user", ['idnumber' => $idnumber], 'id');
    if (!$user) {
        echo json_encode(['error' => 'User not found for given idnumber']);
        exit;
    }
    $userid = $user->id;
}

// Get certificates + course names
$sql = "SELECT ci.id AS issue_id, cert.id AS certificateid, cert.name AS certificate_name, 
               c.fullname AS course_name
        FROM {$CFG->prefix}customcert_issues ci
        JOIN {$CFG->prefix}customcert cert ON ci.customcertid = cert.id
        JOIN {$CFG->prefix}course c ON cert.course = c.id
        WHERE ci.userid = :userid";

$certificates = $DB->get_records_sql($sql, ['userid' => $userid]);

if (empty($certificates)) {
    echo json_encode(['error' => 'No certificates found']);
    exit;
}

// Format result
$result = [];
foreach ($certificates as $cert) {
    $result[] = [
        'course_name'     => $cert->course_name,
        'certificate_name'=> $cert->certificate_name,
        'download_url'    => $CFG->wwwroot .
            "/mod/customcert/my_certificates.php?userid={$userid}" .
            "&certificateid={$cert->certificateid}&downloadcert=1"
    ];
}

echo json_encode($result);
exit;
