define(["core/str","core/toast"],(function(_str,_toast){
/**
   * A JavaScript module that enhances a button and text container to support copy-to-clipboard functionality.
   *
   * This module needs to be loaded by pages/templates/modules that require this functionality.
   *
   * To enable copy-to-clipboard functionality, we need a trigger element (usually a button) and a copy target element
   * (e.g. a div, span, text input, or text area).
   *
   * In the trigger element, we need to declare the <code>data-action="copytoclipboard"</code> attribute and set the
   * <code>data-clipboard-target</code> attribute which is the CSS selector that points to the target element that contains the text
   * to be copied.
   *
   * When the text is successfully copied to the clipboard, a toast message that indicates that the copy operation was a success
   * will be shown. This success message can be customised by setting the <code>data-clipboard-success-message</code> attribute in the
   * trigger element.
   *
   * @module     core/copy_to_clipboard
   * @copyright  2021 Jun Pataleta
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   *
   * @example <caption>Markup for the trigger and target elements</caption>
   * <input type="text" id="textinputtocopy" class="form-control" value="Copy me!" readonly />
   * <button id="copybutton" data-action="copytoclipboard" data-clipboard-target="#textinputtocopy"
   *         data-clipboard-success-message="Success!" class="btn btn-secondary">
   *     Copy to clipboard
   * </button>
   */
const component="assignsubmission_cloudpoodll",copyNodeContentToClipboard=(copyButton,copyTarget)=>(copyTarget.select(),document.execCommand("copy")?(displaySuccessToast(copyButton),!0):(displayFailureToast(),!1)),displaySuccessToast=copyButton=>getSuccessText(copyButton).then((successMessage=>(0,_toast.add)(successMessage,{}))),displayFailureToast=()=>getFailureText().then((message=>(0,_toast.add)(message,{type:"warning"}))),getFailureText=()=>(0,_str.get_string)("unabletocopytoclipboard",component),getSuccessText=copyButton=>copyButton.dataset.clipboardSuccessMessage?Promise.resolve(copyButton.dataset.clipboardSuccessMessage):(0,_str.get_string)("textcopiedtoclipboard",component),getTextFromContainer=container=>container.value?container.value:container.innerText?container.innerText:null;let loaded=!1;loaded||((0,_str.get_strings)([{key:"textcopiedtoclipboard",component:component},{key:"unabletocopytoclipboard",component:component}]),document.addEventListener("click",(e=>{const copyButton=e.target.closest('[data-action="copy"]');if(!copyButton)return;if(!copyButton.dataset.clipboardTarget)return;const copyTarget=document.querySelector(copyButton.dataset.clipboardTarget);if(!copyTarget)return;e.preventDefault();const textToCopy=getTextFromContainer(copyTarget);if(textToCopy)if(navigator.clipboard)navigator.clipboard.writeText(textToCopy).then((()=>displaySuccessToast(copyButton))).catch();else if(copyTarget instanceof HTMLInputElement||copyTarget instanceof HTMLTextAreaElement)copyTarget.focus(),copyNodeContentToClipboard(copyButton,copyTarget)&&copyButton.focus();else{const copyRegion=document.createElement("textarea");copyRegion.value=textToCopy,copyRegion.classList.add("sr-only"),document.body.appendChild(copyRegion),copyNodeContentToClipboard(copyButton,copyRegion),copyRegion.remove(),copyButton.focus()}else displayFailureToast()})),loaded=!0)}));

//# sourceMappingURL=copy_to_clipboard.min.js.map