<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignsubmission_cloudpoodll', language 'en'
 *
 * @package    assignsubmission_cloudpoodll
 * @copyright 2012 Justin Hunt {@link http://www.poodll.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['allowcloudpoodllsubmissions'] = 'Enabled';
$string['default'] = 'Enabled by default';
$string['default_help'] = 'If set, this submission method will be enabled by default for all new assignments.';
$string['enabled'] = 'Cloud Poodll';
$string['enabled_help'] = 'If enabled, students are able to record audio or video (as per the settings) for this assignment.';
$string['nosubmission'] = 'Nothing has been submitted for this assignment';
$string['cloudpoodll'] = 'Cloud Poodll';
//$string['cloudpoodllfilename'] = 'cloudpoodll.html'; //what this for ?
//$string['cloudpoodllsubmission'] = 'Allow Cloud Poodll submission';
$string['pluginname'] = 'Cloud Poodll Submissions';
$string['recorder'] = 'Recorder Type';
$string['recorderaudio'] = 'Audio Recorder';
$string['recordervideo'] = 'Video Recorder';
$string['defaultrecorder'] = 'Recorder Type';
$string['defaultrecorderdetails'] = '';

$string['apiuser']='Poodll API User ';
$string['apiuser_details']='The Poodll account username that authorises Poodll on this site.';
$string['apisecret']='Poodll API Secret ';
$string['apisecret_details']='The Poodll API secret. See <a href= "https://support.poodll.com/support/solutions/articles/19000083076-cloud-poodll-api-secret">here</a> for more details';
$string['enabletranscription']='Enable Transcription';
$string['enabletranscription_details']='Cloud Poodll can transcribe the student speaking if required';
$string['enabletranscode']='Enable Transcode';
$string['enabletranscode_details']='Cloud Poodll can transcode the recording to mp3/mp4';
$string['language']='Cloud Poodll Speaker Language';

$string['useast1']='US East';
$string['tokyo']='Tokyo, Japan';
$string['sydney']='Sydney, Australia';
$string['dublin']='Dublin, Ireland';
$string['ottawa']='Ottawa, Canada';
$string['frankfurt']='Frankfurt, Germany';
$string['london']='London, U.K';
$string['saopaulo']='Sao Paulo, Brazil';
$string['singapore']='Singapore';
$string['mumbai']='Mumbai, India';
$string['capetown'] = 'Capetown, South Africa';
$string['bahrain'] = 'Bahrain';
$string['ningxia'] = 'Ningxia, China (req. Poodll China account)';

$string['forever']='Never expire';
$string['en-us'] = 'English (US)';
$string['en-gb'] = 'English (GB)';
$string['en-au'] = 'English (AU)';
$string['en-in'] = 'English (IN)';
$string['es-es'] = 'Spanish (ES)';
$string['es-us'] = 'Spanish (US)';
$string['fr-fr'] = 'French (FR.)';
$string['fr-ca'] = 'French (CA)';
$string['ko-kr'] = 'Korean';
$string['pt-br'] = 'Portuguese (BR)';
$string['it-it'] = 'Italian (IT)';
$string['de-de'] = 'German (DE)';
$string['hi-in'] = 'Hindi';

$string['ar-ae'] = 'Arabic (Gulf)';
$string['ar-sa'] = 'Arabic (Modern Standard)';
$string['zh-cn'] = 'Chinese (Mandarin-Mainland)';
$string['nl-nl'] = 'Dutch';
$string['da-dk'] = 'Danish';
$string['en-ie'] = 'English (Ireland)';
$string['en-wl'] = 'English (Wales)';
$string['en-ab'] = 'English (Scotland)';
$string['fa-ir'] = 'Farsi';
$string['de-ch'] = 'German (Swiss)';
$string['he-il'] = 'Hebrew';
$string['id-id'] = 'Indonesian';
$string['ja-jp'] = 'Japanese';
$string['ms-my'] = 'Malay';
$string['pt-pt'] = 'Portuguese (PT)';
$string['ru-ru'] = 'Russian';
$string['ta-in'] = 'Tamil';
$string['te-in'] = 'Telugu';
$string['tr-tr'] = 'Turkish';
$string['uk-ua'] = 'Ukranian';
$string['eu-es'] = 'Basque';
$string['fi-fi'] = 'Finnish';
$string['hu-hu'] = 'Hungarian';
$string['sv-se'] = 'Swedish';
$string['no-no'] = 'Norwegian';
$string['nb-no'] = 'Norwegian'; //unused
$string['pl-pl'] = 'Polish';
$string['ro-ro'] = 'Romanian';
$string['mi-nz'] = 'Maori';
$string['bg-bg'] = 'Bulgarian'; // Bulgarian
$string['cs-cz'] = 'Czech'; // Czech
$string['el-gr'] = 'Greek'; // Greek
$string['hr-hr'] = 'Croatian'; // Croatian
$string['hu-hu'] = 'Hungarian'; // Hungarian
$string['lt-lt'] = 'Lithuanian'; // Lithuanian
$string['lv-lv'] = 'Latvian'; // Latvian
$string['sk-sk'] = 'Slovak'; // Slovak
$string['sl-si'] = 'Slovenian'; // Slovenian
$string['is-is'] = 'Icelandic'; // Icelandic
$string['mk-mk'] = 'Macedonian'; // Macedonian
$string['no-no'] = 'Norwegian'; // Norwegian
$string['sr-rs'] = 'Serbian'; // Serbian
$string['vi-vn'] = 'Vietnamese'; // Vietnamese



$string['awsregion']='AWS Region';
//$string['region']='AWS Region';
$string['expiredays']='Cloud Poodll Days to keep file';


$string['timelimit'] = 'Cloud Poodll Rec. Time Limit';
$string['currentsubmission'] = 'Current Submission:';
$string['yes'] = 'yes';
$string['no'] = 'no';

//$string['showcurrentsubmission'] = 'Show Current Submission';
//$string['showcurrentsubmissiondetails'] = 'Show previously recorded submission on submission form.';

$string['displayaudioplayersingle'] = 'Show audio player(normal)';
$string['displayaudioplayerlist'] = 'Show audio player(lists)';

$string['displaysizesingle'] = 'Video player size(normal)';
$string['displaysizesingledetails'] = '';
$string['displaysizelist'] = 'Video player size(in lists)';
$string['displaysizelistdetails'] = '';

//$string['shownoimage'] = 'Do not display image';

$string['setting_audio_heading'] = 'Audio player settings';
$string['setting_audio_heading_details'] = 'Settings controlling player appearance in submission review and list pages';
$string['setting_video_heading'] = 'Video player settings';
$string['setting_video_heading_details'] = 'Settings controlling player appearance in submission review and list pages';
//$string['setting_snapshot_heading'] = 'Snapshot image settings';
//$string['setting_snapshot_heading_details'] = 'Settings controlling image appearance in submission review and list pages';
//$string['setting_whiteboard_heading'] = 'Whiteboard image settings';
//$string['setting_whiteboard_heading_details'] = 'Settings controlling image appearance in submission review and list pages';
$string['deletesubmission'] = 'Delete this submission.';
$string['reallydeletesubmission'] = 'Really delete this submission?';

$string['cloudpoodll:use'] = 'Allow use of Cloud Poodll submissions';
$string['privacy:metadata:cloudpoodllcom'] = 'The assignsubmission_cloudpoodll plugin stores recordings in AWS S3 buckets via cloud.poodll.com.';
$string['privacy:metadata:cloudpoodllcom:userid'] = 'The assignsubmission_cloudpoodll plugin includes the moodle userid in the urls of recordings.';
$string['privacy:metadata:assignmentid'] = 'Assignment identifier';
$string['privacy:metadata:filepurpose'] = 'File urls of submitted recordings.';
$string['privacy:metadata:submissionpurpose'] = 'The submission ID that links to submissions for the user.';
$string['privacy:metadata:tablepurpose'] = 'Stores the text and URLs that make the submission for each attempt.';
$string['privacy:metadata:transcriptpurpose'] = 'The transcript for this attempt of the assignment.';
$string['privacy:metadata:fulltranscriptpurpose'] = 'The transcript with metadata for this attempt of the assignment.';
$string['privacy:metadata:vttpurpose'] = 'The subtitle rendering of transcript for this attempt of the assignment.';
$string['privacy:path'] = 'Submission Text';



$string['recordertype'] = 'Cloud Poodll Rec. Type';
$string['recorderskin'] = 'Cloud Poodll Rec. Skin';
$string['skinplain'] = 'Plain';
$string['skinbmr'] = 'Burnt Rose';
$string['skinfresh'] = 'Fresh (audio only)';
$string['skin123'] = 'One Two Three';
$string['skinonce'] = 'Once';
$string['skinupload'] = 'Upload';
$string['skinscreen'] = 'Screen Recorder (video)';

$string['fallback'] = 'non-HTML5 Fallback';
$string['fallbackdetails'] = 'If the browser does not support HTML5 recording for the selected mediatype, fallback to an upload screen or a warning.';
$string['fallbackupload'] = 'Upload';
$string['fallbackiosupload'] = 'iOS: upload, else warning';
$string['fallbackwarning'] = 'Warning';

$string['playertype']='Cloud Poodll Transcript Display (teacher)';
$string['playertypestudent']='Cloud Poodll Transcript Display(student)';
$string['playertypedefault']='No transcript.';
$string['playertypeinteractivetranscript']='Interactive transcript';
$string['playertypestandardtranscript']='Static transcript';
$string['defaultplayertype']='Transcript display(teacher)';
$string['defaultplayertypestudent']='Transcript display(student)';
$string['defaultplayertypedetails']='Use the interactive or static transcript player if you are transcribing or show no transcript';
$string['transcripttitle']='Transcript';

//these errors are displayed on settings page
$string['displaysubs'] = '{$a->subscriptionname} : expires {$a->expiredate}';
$string['noapiuser'] = "No API user entered. This plugin will not work correctly.";
$string['noapisecret'] = "No API secret entered. This plugin will not work correctly.";
$string['credentialsinvalid'] = "The API user and secret entered could not be used to get access. Please check them.";
$string['appauthorised']= "Assign Submission Cloud Poodll is authorised for this site.";
$string['appnotauthorised']= "Assign Submission Cloud Poodll  is NOT authorised for this site.";
$string['refreshtoken']= "Refresh license information";
$string['notokenincache']= "Refresh to see license information. Contact Poodll support if there is a problem.";

//these errors are displayed on activity page
$string['nocredentials'] = 'API user and secret not entered. Please enter them on <a href="{$a}">the settings page.</a> You can get them from <a href="https://poodll.com/member">Poodll.com.</a>';
$string['novalidcredentials'] = 'API user and secret were rejected and could not gain access. Please check them on <a href="{$a}">the settings page.</a> You can get them from <a href="https://poodll.com/member">Poodll.com.</a>';
$string['nosubscriptions'] = "There is no current subscription for this site/plugin.";

$string['clicktohide']= "Hide current submission";
$string['clicktoshow']= "Show current submission";

$string['transcribernone']= "No transcription";
$string['transcriberamazon']= "Normal transcription";
$string['transcribergooglecloud']= "Fast transcription(audio only)";

$string['recorderdisplayname']= "Recorder";
$string['customname']= "Custom name";
$string['customnamedetails']= "Set a custom name for the submission field(ie not 'Recorder') as displayed inside the plugin";

$string['numwords'] = '({$a} words)';
$string['divider']= '---------------{$a}----------------';
$string['customdivider']= '---------------{$a->customname} ("{$a->pluginname}")----------------';


$string['showaudiolightbox']="Show filename(lightbox)";
$string['showvideolightbox']="Show filename (lightbox)";
$string['audiosingledisplay']="Show audio player (single)";
$string['audiolistdisplay']="Show audio player (in lists)";
$string['videosingledisplay']="Video player size (single)";
$string['videolistdisplay']="Video player size (in lists)";
$string['shownovideo'] = 'Show filename';
$string['shownoaudio'] = 'Show filename';
//$string['videoplaceholder'] = ' [video submitted] ';
//$string['audioplaceholder'] = ' [audio submitted] ';
$string['safesave'] = 'Enable Safe Save - disables assignment submit button until Cloud Poodll upload is complete. ';
$string['cloudpoodll_cleanup_task']="CloudPoodll Assign Submission cleanup";
//$string['secureplayback']='Restricted playback';
$string['enablesecureplayback']='Restricted playback';
$string['enablesecureplayback_details']='If enabled, playback URLs for submissions are time limited and will expire after 60 minutes.';
$string['enableaudio'] = "Enable audio recording";
$string['enablevideo'] = "Enable video recording";
//$string['managecredsheading'] = "Manage Poodll API Credentials";
//$string['refreshtoken_desc'] = "Manage Poodll API Credentials";

$string['freetrial'] = "Get Cloud Poodll API Credentials and a Free Trial";
$string['freetrial_desc'] = "A dialog should appear that allows you to register for a free trial with Poodll. After registering you should login to the members dashboard to get your API user and secret. And to register your site URL.";
//$string['memberdashboard'] = "Member Dashboard";
//$string['memberdashboard_desc'] = "";
$string['fillcredentials']="Set API user and secret with existing credentials";
$string['textcopiedtoclipboard'] = 'Text copied to clipboard';
$string['unabletocopytoclipboard'] = 'Unable to copy text to the clipboard';
$string['noaudiofilters'] = 'Disable audio noise filters';
$string['noaudiofilters_details'] = ' Turning off echo cancellation and noise suppression can be useful when shadowing or recording music.';
$string['noaudiofilters'] = 'Disable audio noise filters';
$string['noaudiofilters_desc'] = 'Disable audio noise filters - can be useful when shadowing or recording music.';
$string['cloudpoodllserver'] = 'Cloud Poodll Server';
$string['cloudpoodllserver_details'] = 'The server to use for Cloud Poodll. Only change this if Poodll has provided a different one.';
